@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.services')}}">Service</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Services</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action=" {{ route('admin.save-slot') }}"> -->
                        <form id="addSlot" action=" {{ route('admin.save-slot') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="page-table-header mb-5">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <div class="doctor-table-blk">
                                                    <h3>Add Slot</h3>
                                                </div>
                                            </div>
                                            <div class="col-auto text-end float-end ms-auto download-grp">
                                                <div class="note-checkit">
                                                    <label class="custom_check">
                                                        <input type="checkbox" name="select_specialist" id="checkAll">
                                                        <span class="checkmark"></span> All Day
                                                    </label>
                                                </div>
                                                <!-- <a href="javascript:;" class="custom-badge status-green"><i class=" fas fa-plus"></i> Appply To All Days </a> -->
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Provider <span class="login-danger">*</span></label>
                                        <select class="form-control select" name="provider" id="provider">
                                            <option>--Select Provider--</option>
                                            @foreach(App\Models\Therapist::orderBy('full_name','ASC')->get() as $item)
                                            <option value=" {{$item->id}}">{{$item->full_name}}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="provider_category" id="provider_category">
                                    </div>
                                </div>
                                <div class=" col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Break Time(in min) <span class="login-danger">*</span></label>
                                        <input class="form-control" required name="break_time" type="text" value="30">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-heading">
                                            <h4>Set Available Slots</h4>
                                        </div>

                                    </div>
                                </div>
                                @foreach(days() as $item)
                                <div class="row">
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <input type="checkbox" id="checkItem_{{$item}}" class="checkItem" value="{{$item}}" name="day[]">
                                            <span class="checkmark"></span> {{$item}}
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Service <span class="login-danger">*</span></label>
                                            <select class="form-control select" disabled name="service[]" id="service_{{$item}}">
                                                <option>---Select Service---</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Start Time <span class="login-danger">*</span></label>
                                            <div class="time-icon">
                                                <input type="text" disabled class="form-control datetimepicker01 starttime" id="start_time_{{$item}}" name="start_time[]">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>End Time <span class="login-danger">*</span></label>
                                            <div class="time-icon">
                                                <input type="text" disabled class="form-control  datetimepicker01 endtime" id="end_time_{{$item}}" name="end_time[]">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="form-group local-forms">
                                            <div class="add-group">
                                                <a href=" javascript:void(0);" id="remove_training" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="day_{{$item}}"></div>
                                @endforeach


                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Save</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('body').on('click', '#addMoreTime', function(e) {
            e.preventDefault();
            var day = $(this).data('value');
            var therapist = $('#provider').val();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.addMoreTime-html') }}",
                method: "GET",
                data: {
                    'day': day,
                    'therapist_id': therapist
                },
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#day_' + day).append(result);
                }
            });
        });


        $('body').on('click', '#remove_slot', function(e) {
            var day = $(this).data('value');
            $(this).closest("#remove-row-" + day).remove();
            // $('#remove-row').hide('slow');
        });

        $("#checkAll").click(function() {
            $('input:checkbox').not(this).prop('checked', this.checked);
            $.each(['Sunday', 'Monday', 'Tuesday', 'Wenesday', 'Thursday', 'Friday', 'Saturday'], function(index, day) {
                if ($('#checkItem_' + day).is(':checked')) {
                    $('#start_time_' + day).removeAttr('disabled', false);
                    $('#end_time_' + day).removeAttr('disabled', false);
                    $('#service_' + day).removeAttr('disabled', false);
                    $('.add_' + day).css({
                        'pointer-events': 'auto'
                    });
                } else {
                    $('#start_time_' + day).attr('disabled', true);
                    $('#end_time_' + day).attr('disabled', true);
                    $('#service_' + day).attr('disabled', true);
                    $('.add_' + day).css({
                        'pointer-events': 'none'
                    });
                }
            });


        });

        // $('body').on('change', '#call_method', function(e) {
        //     $(this).closest("#remove-row").remove();
        //     // $('#remove-row').hide('slow');
        // });

        $('#addSlot').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            $("#js-loader").fadeIn();
            let formData = new FormData(this);
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Slot Added Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $(".checkItem").on("change", function() {
            var day = $(this).val();
            if ($('#checkItem_' + day).is(':checked')) {
                $('#start_time_' + day).removeAttr('disabled', false);
                $('#end_time_' + day).removeAttr('disabled', false);
                $('#service_' + day).removeAttr('disabled', false);
                $('.add_' + day).css({
                    'pointer-events': 'auto'
                });
            } else {
                $('#start_time_' + day).attr('disabled', true);
                $('#end_time_' + day).attr('disabled', true);
                $('#service_' + day).attr('disabled', true);
                $('.add_' + day).css({
                    'pointer-events': 'none'
                });
            }
        });

        $('select[name="provider"]').on('change', function() {
            var catId = $(this).val();
            if (catId) {
                $.ajax({
                    url: "{{ route('admin.load-service-html') }}",
                    data: {

                        'id': catId
                    },
                    type: "GET",
                    //  dataType: "json",
                    success: function(data) {
                        $('.select').append(data);

                    }

                })

                $.ajax({
                    url: "{{ route('admin.provider-category') }}",
                    data: {

                        'id': catId
                    },
                    type: "GET",
                    //  dataType: "json",
                    success: function(data) {
                        $('#provider_category').val(data);
                    }

                })
            }
        });
    </script>
    @endsection